<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 05.12.13 12:03
 */

namespace VM\PackageGeneratorBundle\Services\Export;


class ManifestCreator {

    /**
     * @var DOMDocument
     */
    protected $XML;


    /**
     * @var \DOMElement
     */
    protected $Root;


    public function __construct()
    {
        $this->XML = new \DOMDocument('1.0', 'utf-8');
        $this->Root = $this->XML->createElement('manifest');
        $this->XML->appendChild($this->Root);
    }

    public function get($authCode, $title)
    {
        $this->Root->setAttribute('formatVersion', '0.0.4');
        $this->Root->setAttribute('packageId', $authCode);
        $this->Root->setAttribute('packageVersion', '0.0.2');
        $this->Root->setAttribute('icon', 'files/icon.png');
        $this->Root->setAttribute('label', 'Gra Biznesowa');
        $this->Root->setAttribute('pdf', 'files/pdf.pdf');
        $this->Root->setAttribute('structureXML', 'structure.xml');
        $this->Root->setAttribute('author', 'vm.pl');
        $this->Root->setAttribute('productCode', $authCode);
        $this->Root->setAttribute('description', $title);

        return str_replace('<?xml version="1.0" encoding="utf-8"?>' . "\n", '', $this->XML->saveXML());

    }
} 